/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.utils.jsse;

import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import filenet.ws.utils.jsse.FnTrustManager;
import filenet.ws.utils.jsse.IWSJSSEContext;
import filenet.ws.utils.jsse.WSJSSE;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Hashtable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.axis.components.net.JSSESocketFactory;
import org.apache.axis.components.net.SecureSocketFactory;

public class FnJSSESocketFactory
extends JSSESocketFactory
implements SecureSocketFactory,
IWSJSSEContext {
    protected static Logger logger = Logger.getLogger("filenet.vw.ComponentIntegrator.WebServices.SSL");
    protected static final String m_className = "FnJSSESocketFactory";
    private String keystoreFile = null;
    private char[] keystorePassword = null;
    private String truststoreFile = null;
    private char[] truststorePassword = null;
    boolean autoAccept = false;

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:04:38  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.6  $";
    }

    public FnJSSESocketFactory(Hashtable attributes) {
        super(attributes);
    }

    protected void initFactory() throws IOException {
        String m_method = "initFactory";
        logger.entering(m_className, "initFactory");
        try {
            WSJSSE.setupJSSEProperties(this);
            SSLContext context = this.getContext();
            this.sslFactory = context.getSocketFactory();
        }
        catch (Throwable e) {
            logger.throwing(m_className, "initFactory", e);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
        finally {
            logger.exiting(m_className, "initFactory");
        }
    }

    public void setTruststore(String val) {
        if (val == null) {
            return;
        }
        this.truststoreFile = val;
    }

    public void setTruststorePassword(String val) {
        if (val == null) {
            return;
        }
        this.truststorePassword = val.toCharArray();
    }

    public void setKeystore(String val) {
        if (val == null) {
            return;
        }
        this.keystoreFile = val;
    }

    public void setKeystorePassword(String val) {
        if (val == null) {
            return;
        }
        this.keystorePassword = val.toCharArray();
    }

    public void setAutoAccept(boolean val) {
        this.autoAccept = val;
    }

    public String getTruststore() {
        return this.truststoreFile;
    }

    public char[] getTruststorePassword() {
        return this.truststorePassword;
    }

    public String getKeystore() {
        return this.keystoreFile;
    }

    public char[] getKeystorePassword() {
        return this.keystorePassword;
    }

    public boolean setAutoAccept() {
        return this.autoAccept;
    }

    public void traceStoreProperties() {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(m_className, "traceStoreProperties", "autoAccept=" + new Boolean(this.autoAccept).toString() + ", trustStore=" + this.truststoreFile + ", keystore=" + this.keystoreFile);
        }
    }

    public SSLSocketFactory getSSLSocketFactory() throws IOException {
        this.initFactory();
        return this.sslFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SSLContext getContext() throws Exception {
        String m_method = "getContext";
        logger.entering(m_className, "getContext");
        try {
            if (logger.isFinest()) {
                logger.finest(m_className, "getContext", "getting keystore.");
            }
            KeyManagerFactory kmf = null;
            try {
                KeyStore kstore = FnJSSESocketFactory.initKeyStore(this.keystoreFile, this.keystorePassword);
                WSJSSE wsjsse = WSJSSE.getInstance();
                kmf = KeyManagerFactory.getInstance(wsjsse.getKeyManagerAlgorithm());
                kmf.init(kstore, this.keystorePassword);
            }
            catch (Exception e) {
                logger.throwing(m_className, "getContext", e);
                logger.warning(m_className, "getContext", "No Key Manager.  Client Authentication is not enabled.");
            }
            KeyStore tstore = null;
            try {
                tstore = FnJSSESocketFactory.initKeyStore(this.truststoreFile, this.truststorePassword);
            }
            catch (Exception e) {
                tstore = FnJSSESocketFactory.getDefaultKeyStore(this.truststorePassword);
            }
            TrustManager[] tms = new TrustManager[]{new FnTrustManager(tstore, this.truststoreFile, this.truststorePassword, this.autoAccept)};
            WSJSSE wsjsse = WSJSSE.getInstance();
            SSLContext context = SSLContext.getInstance(wsjsse.getProtocol());
            context.init(kmf == null ? null : kmf.getKeyManagers(), tms, new SecureRandom());
            SSLContext sSLContext = context;
            return sSLContext;
        }
        finally {
            logger.exiting(m_className, "getContext");
        }
    }

    private static KeyStore getDefaultKeyStore(char[] keystorePassword) throws Exception {
        WSJSSE wsjsse = WSJSSE.getInstance();
        KeyStore keyStore = KeyStore.getInstance(wsjsse.getKeyStoreType());
        keyStore.load(null, keystorePassword);
        return keyStore;
    }

    protected static KeyStore initKeyStore(String keystoreFile, char[] keystorePassword) throws IOException {
        String m_method = "initKeyStore:" + keystoreFile;
        logger.entering(m_className, m_method);
        InputStream istream = null;
        try {
            WSJSSE wsjsse = WSJSSE.getInstance();
            File f = new File(keystoreFile);
            if (!f.exists()) {
                KeyStore keyStore = FnJSSESocketFactory.getDefaultKeyStore(keystorePassword);
                return keyStore;
            }
            KeyStore kstore = KeyStore.getInstance(wsjsse.getKeyStoreType());
            istream = new FileInputStream(keystoreFile);
            kstore.load(istream, keystorePassword);
            KeyStore keyStore = kstore;
            return keyStore;
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            throw new IOException("Exception trying to load keystore " + keystoreFile + ": " + ex.getMessage());
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (Exception e) {}
            }
            logger.exiting(m_className, m_method);
        }
    }
}

